/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.thebottom;

import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.cards.curses.Injury;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.AbstractImageEvent;
import com.megacrit.cardcrawl.events.GenericEventDialog;
import com.megacrit.cardcrawl.helpers.CardLibrary;
import com.megacrit.cardcrawl.helpers.RelicLibrary;
import com.megacrit.cardcrawl.helpers.ScreenShake;
import com.megacrit.cardcrawl.localization.EventStrings;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import com.megacrit.cardcrawl.vfx.cardManip.ShowCardAndObtainEffect;

public class GoldenIdolEvent
extends AbstractImageEvent {
    public static final String ID = "Golden Idol";
    private static final EventStrings eventStrings = CardCrawlGame.languagePack.getEventString("Golden Idol");
    public static final String NAME = GoldenIdolEvent.eventStrings.NAME;
    public static final String[] DESCRIPTIONS = GoldenIdolEvent.eventStrings.DESCRIPTIONS;
    public static final String[] OPTIONS = GoldenIdolEvent.eventStrings.OPTIONS;
    private static final String DIALOG_START = DESCRIPTIONS[0];
    private static final String DIALOG_BOULDER = DESCRIPTIONS[1];
    private static final String DIALOG_CHOSE_RUN = DESCRIPTIONS[2];
    private static final String DIALOG_CHOSE_FIGHT = DESCRIPTIONS[3];
    private static final String DIALOG_CHOSE_FLAT = DESCRIPTIONS[4];
    private static final String DIALOG_IGNORE = DESCRIPTIONS[5];
    private int screenNum = 0;
    private int hpLoss;
    private int maxHpLoss;
    private static final float HP_LOSS_PERCENT = 0.25f;
    private static final float MAX_HP_LOSS_PERCENT = 0.08f;

    public GoldenIdolEvent() {
        super(NAME, DIALOG_START, "images/events/goldenIdol.jpg");
        GenericEventDialog.setDialogOption(OPTIONS[0]);
        GenericEventDialog.setDialogOption(OPTIONS[1]);
        this.hpLoss = (int)((float)AbstractDungeon.player.maxHealth * 0.25f);
        this.maxHpLoss = (int)((float)AbstractDungeon.player.maxHealth * 0.08f);
        if (this.maxHpLoss < 1) {
            this.maxHpLoss = 1;
        }
    }

    @Override
    protected void buttonEffect(int buttonPressed) {
        block0 : switch (this.screenNum) {
            case 0: {
                switch (buttonPressed) {
                    case 0: {
                        GenericEventDialog.updateBodyText(DIALOG_BOULDER);
                        AbstractDungeon.getCurrRoom().spawnRelicAndObtain(Settings.WIDTH / 2, Settings.HEIGHT / 2, RelicLibrary.getRelic(ID).makeCopy());
                        CardCrawlGame.screenShake.mildRumble(5.0f);
                        CardCrawlGame.sound.play("BLUNT_HEAVY");
                        this.screenNum = 1;
                        GenericEventDialog.updateDialogOption(0, OPTIONS[2], CardLibrary.getCopy("Injury"));
                        GenericEventDialog.updateDialogOption(1, OPTIONS[3] + this.hpLoss + OPTIONS[4]);
                        GenericEventDialog.setDialogOption(OPTIONS[5] + this.maxHpLoss + OPTIONS[6]);
                        break block0;
                    }
                }
                GenericEventDialog.updateBodyText(DIALOG_IGNORE);
                this.screenNum = 2;
                GenericEventDialog.updateDialogOption(0, OPTIONS[1]);
                GenericEventDialog.clearRemainingOptions();
                this.logMetric("Ignored");
                break;
            }
            case 1: {
                switch (buttonPressed) {
                    case 0: {
                        CardCrawlGame.screenShake.shake(ScreenShake.ShakeIntensity.MED, ScreenShake.ShakeDur.MED, false);
                        GenericEventDialog.updateBodyText(DIALOG_CHOSE_RUN);
                        AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(new Injury(), (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f));
                        UnlockTracker.markCardAsSeen("Injury");
                        this.screenNum = 2;
                        GenericEventDialog.updateDialogOption(0, OPTIONS[1]);
                        this.logMetric("Take Wound");
                        GenericEventDialog.clearRemainingOptions();
                        break block0;
                    }
                    case 1: {
                        GenericEventDialog.updateBodyText(DIALOG_CHOSE_FIGHT);
                        CardCrawlGame.screenShake.shake(ScreenShake.ShakeIntensity.MED, ScreenShake.ShakeDur.MED, false);
                        CardCrawlGame.sound.play("BLUNT_FAST");
                        AbstractDungeon.player.damage(new DamageInfo(null, this.hpLoss));
                        this.screenNum = 2;
                        GenericEventDialog.updateDialogOption(0, OPTIONS[1]);
                        this.logMetric("Take Damage");
                        GenericEventDialog.clearRemainingOptions();
                        break block0;
                    }
                    case 2: {
                        GenericEventDialog.updateBodyText(DIALOG_CHOSE_FLAT);
                        AbstractDungeon.player.decreaseMaxHealth(this.maxHpLoss);
                        CardCrawlGame.screenShake.shake(ScreenShake.ShakeIntensity.MED, ScreenShake.ShakeDur.MED, false);
                        CardCrawlGame.sound.play("BLUNT_FAST");
                        this.screenNum = 2;
                        GenericEventDialog.updateDialogOption(0, OPTIONS[1]);
                        this.logMetric("Lose Max HP");
                        GenericEventDialog.clearRemainingOptions();
                        break block0;
                    }
                }
                this.openMap();
                break;
            }
            case 2: {
                this.openMap();
                break;
            }
            default: {
                this.openMap();
            }
        }
    }

    public void logMetric(String actionTaken) {
        AbstractEvent.logMetric(ID, actionTaken);
    }
}

